#!/bin/bash
# The script copies certificates, which are supplied with the program, to the config folder 
NAME="streamer"

CRT_EXT=".crt"
KEY_EXT=".key"
CSR_EXT=".csr"
CACRT_EXT="-ca.crt"

for i in "$@"
do
case $i in
    -s=*|--source_path=*)
    SOURCE_DIR1="${i#*=}"
    shift
    ;;
    -d=*|--destpath=*)
    DEST_PATH="${i#*=}"
    shift
    ;;
    *)
          # unknown option
    ;;
esac
done

if [ -z $DEST_PATH  ]; then
      DEST_PATH="/etc/flussonic"; 
fi

if [ ! -d $DEST_PATH  ]; then
  echo "Destination folder ${DEST_PATH} doesn't exist"
  exit 0
fi  

# Check flag
if [ -f "${DEST_PATH}/.default_certificate_copied" ]; then
  exit 0  
fi

NAME_OLD="flussonic" 
# Check and rename certificates with old name
if [ -f "${DEST_PATH}/${NAME_OLD}${CRT_EXT}" ]; then
  mv "${DEST_PATH}/${NAME_OLD}${CRT_EXT}" "${DEST_PATH}/${NAME}${CRT_EXT}"
  touch "${DEST_PATH}/.default_certificate_copied" #set flag
  echo "rename certificate"
fi

if [ -f "${DEST_PATH}/${NAME_OLD}${KEY_EXT}" ]; then
  mv "${DEST_PATH}/${NAME_OLD}${KEY_EXT}" "${DEST_PATH}/${NAME}${KEY_EXT}"
  echo "rename key"
fi

if [ -f "${DEST_PATH}/${NAME_OLD}${CACRT_EXT}" ]; then
  mv "${DEST_PATH}/${NAME_OLD}${CACRT_EXT}" "${DEST_PATH}/${NAME}${CACRT_EXT}"
  echo "rename ca certificate"
fi

if [ -f "${DEST_PATH}/${NAME_OLD}${CSR_EXT}" ]; then
  mv "${DEST_PATH}/${NAME_OLD}${CSR_EXT}" "${DEST_PATH}/${NAME}${CSR_EXT}"
fi

# Check if certificates were copied before
if [ -f "${DEST_PATH}/${NAME}${CRT_EXT}" ]; then
  exit 0  
fi


#----------------
if [ -z $SOURCE_DIR1  ]; then
  if [ -d "/opt/flussonic/priv"  ]; 
    then 
      SOURCE_DIR1="/opt/flussonic/priv/ssl"; 
    else 
      SOURCE_DIR1="/opt/streamer/priv/ssl"; 
  fi
   
  if [ -d "/opt/flussonic/lib"  ]; 
    then 
      SOURCE_DIR2=$(ls -d /opt/flussonic/lib/web-*/priv/ssl); 
    else 
      SOURCE_DIR2=$(ls -d /opt/streamer/lib/web-*/priv/ssl); 
  fi
fi

# find certificates from box 
if [ -f "${SOURCE_DIR2}/${NAME}${CRT_EXT}" ]; then
    SOURCE_PATH="${SOURCE_DIR2}/${NAME}"
fi

if [ -f "${SOURCE_DIR1}/${NAME}${CRT_EXT}" ]; then
    SOURCE_PATH="${SOURCE_DIR1}/${NAME}"
fi

# if finds, copies them 
if [ ! -z "${SOURCE_PATH}" ]; then
  cp "${SOURCE_PATH}${CRT_EXT}" "${DEST_PATH}/${NAME}${CRT_EXT}"
  cp "${SOURCE_PATH}${KEY_EXT}" "${DEST_PATH}/${NAME}${KEY_EXT}"
  cp "${SOURCE_PATH}${CACRT_EXT}" "${DEST_PATH}/${NAME}${CACRT_EXT}"
  cp "${SOURCE_PATH}${CSR_EXT}" "${DEST_PATH}/${NAME}${CSR_EXT}"
  touch "${DEST_PATH}/.default_certificate_copied" #set flag
fi
